package edu.uky.ai.lp.ai;

import edu.uky.ai.lp.Action;
import edu.uky.ai.lp.Game;
import edu.uky.ai.lp.Result;

/**
 * Represents a player in "Hunt the Wumpus."
 * 
 * @author Stephen G. Ware
 */
public interface Agent {

	/**
	 * Chooses the next move for the player to make.
	 * 
	 * @param game the current state of the game
	 * @return the action the player should take
	 */
	public Action chooseAction(Game game);
	
	/**
	 * Alerts the player to the result of the most recent action.
	 * 
	 * @param result the result of the most recent action
	 */
	public void observe(Result result);
}
